"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface

from enum import Enum

def printConfig(config) -> None:
    """print configuration"""
    objDesc = config.DESCRIPTOR
    for config_section in objDesc.fields:
        if config_section.name != "version":
            config = objDesc.fields_by_name.get(config_section.name)
            print(f"{config_section.name}:")
            names = []
            for field in config.message_type.fields:
                tmp_name = f"{config_section.name}.{field.name}"
                names.append(tmp_name)
            for temp_name in sorted(names):
                print(f"    {temp_name}")

interface = meshtastic.serial_interface.SerialInterface()
node = interface.getNode('^local')

print("Module config")
printConfig(node.moduleConfig)
#print(node.moduleConfig)
print("Local config")
printConfig(node.localConfig)
#print(node.localConfig)

#if node.localConfig.network.wifi_enabled:
#    print("wifi enabled!")

#print ("SSID: " + str(node.localConfig.network.wifi_ssid))
#print ("PSK: " + str(node.localConfig.network.wifi_psk))
#print ("NTP Server: " + str(node.localConfig.network.ntp_server))

interface.close()
